# ================================================================
# Windows 11 Anpassungsskript - ARM64 Version v5
# Fuer Qualcomm Snapdragon Prozessoren
# ================================================================

Write-Host "========================================" -ForegroundColor Cyan
Write-Host " Windows 11 Anpassung (ARM64) v5" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# --- 1. Kompakte Ansicht im Explorer ---
Write-Host "[1/6] Setze Explorer-Einstellungen..." -ForegroundColor Yellow
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "UseCompactMode" -Value 1
Write-Host "      OK Kompakte Ansicht aktiviert" -ForegroundColor Green

# --- 2. Taskleisten-Einstellungen ---
Write-Host "[2/6] Passe Taskleiste an..." -ForegroundColor Yellow
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "TaskbarAl" -Value 0
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "TaskbarSmallIcons" -Value 0
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Search" -Name "SearchboxTaskbarMode" -Value 0
Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -Name "TaskbarDa" -Value 0

Write-Host "      OK Taskleiste links positioniert" -ForegroundColor Green
Write-Host "      OK Suchfeld ausgeblendet" -ForegroundColor Green
Write-Host "      OK Widgets ausgeblendet" -ForegroundColor Green

Stop-Process -Name explorer -Force
Start-Sleep -Seconds 1
Start-Process explorer.exe
Start-Sleep -Seconds 2

# --- 3. Windows 11 Kontextmenu direkt deaktivieren (Registry) ---
Write-Host "[3/6] Deaktiviere Windows 11 Kontextmenu (direkt via Registry)..." -ForegroundColor Yellow
$contextMenuKey = "HKCU:\Software\Classes\CLSID\{86ca1aa0-34aa-4e8b-a509-50c905bae2a2}\InprocServer32"
if (-not (Test-Path $contextMenuKey)) {
    New-Item -Path $contextMenuKey -Force | Out-Null
}
Set-ItemProperty -Path $contextMenuKey -Name "(Default)" -Value "" -Force
Write-Host "      OK Windows 11 Kontextmenu deaktiviert" -ForegroundColor Green

# --- 4. ExplorerPatcher ARM64 herunterladen & installieren ---
Write-Host "[4/6] Lade ExplorerPatcher ARM64 herunter..." -ForegroundColor Yellow
$epUrl = "https://github.com/valinet/ExplorerPatcher/releases/latest/download/ep_setup_arm64.exe"
$epInstaller = "$env:TEMP\ep_setup_arm64.exe"

try {
    Invoke-WebRequest -Uri $epUrl -OutFile $epInstaller -ErrorAction Stop
    Write-Host "      OK Download erfolgreich" -ForegroundColor Green
    
    Write-Host "[5/6] Installiere ExplorerPatcher..." -ForegroundColor Yellow
    Start-Process -FilePath $epInstaller -ArgumentList "/silent" -Wait
    Start-Sleep -Seconds 3
    Write-Host "      OK Installation abgeschlossen" -ForegroundColor Green
} catch {
    Write-Host "      FEHLER beim Download/Installation!" -ForegroundColor Red
    Write-Host "      Bitte manuell von GitHub herunterladen:" -ForegroundColor Yellow
    Write-Host "      $epUrl" -ForegroundColor Yellow
    Write-Host ""
    Write-Host "      Script laeuft trotzdem weiter (Basis-Anpassungen wurden gemacht)..." -ForegroundColor Yellow
    Start-Sleep -Seconds 3
}

# --- 5. ExplorerPatcher Einstellungen setzen ---
Write-Host "[6/6] Konfiguriere ExplorerPatcher..." -ForegroundColor Yellow
$epBase = "HKCU:\Software\Valinet\ExplorerPatcher"
if (-not (Test-Path $epBase)) { New-Item -Path $epBase -Force | Out-Null }
if (-not (Test-Path "$epBase\file_explorer")) { New-Item -Path "$epBase\file_explorer" -Force | Out-Null }
if (-not (Test-Path "$epBase\start_menu")) { New-Item -Path "$epBase\start_menu" -Force | Out-Null }

Set-ItemProperty -Path "$epBase\file_explorer" -Name "disable_win11_context_menu" -Value 1 -Force
Write-Host "      OK ExplorerPatcher: Kontextmenu-Einstellung gesetzt" -ForegroundColor Green

Set-ItemProperty -Path "$epBase\file_explorer" -Name "use_classic_drive_groups" -Value 1 -Force
Set-ItemProperty -Path "$epBase\file_explorer" -Name "ribbon_enabled" -Value 1 -Force
Write-Host "      OK ExplorerPatcher: Ribbon-Interface aktiviert" -ForegroundColor Green

Set-ItemProperty -Path "$epBase\start_menu" -Name "style" -Value 1 -Force
Write-Host "      OK ExplorerPatcher: Windows 10 Startmenu konfiguriert" -ForegroundColor Green

$startMenuValue = (Get-ItemProperty -Path "$epBase\start_menu" -Name "style" -ErrorAction SilentlyContinue).style
if ($startMenuValue -eq 1) {
    Write-Host "      OK Startmenu-Einstellung bestaetigt (style=1)" -ForegroundColor Green
} else {
    Write-Host "      WARNUNG: Startmenu-Einstellung konnte nicht bestaetigt werden!" -ForegroundColor Red
}

$epExe = "$env:LOCALAPPDATA\Programs\EP\EP.exe"
if (Test-Path $epExe) {
    Start-Process $epExe -WindowStyle Hidden
    Start-Sleep -Seconds 3
    Write-Host "      OK ExplorerPatcher gestartet" -ForegroundColor Green
} else {
    Write-Host "      INFO: ExplorerPatcher nicht unter $epExe gefunden" -ForegroundColor Yellow
    Write-Host "      Das ist normal, wenn die Installation fehlgeschlagen ist." -ForegroundColor Yellow
}

Stop-Process -Name explorer -Force
Start-Sleep -Seconds 1
Start-Process explorer.exe

Write-Host ""
Write-Host "========================================" -ForegroundColor Green
Write-Host " Installation abgeschlossen!" -ForegroundColor Green
Write-Host "========================================" -ForegroundColor Green
Write-Host ""
Write-Host "WICHTIG:" -ForegroundColor Yellow
Write-Host "-> Ein NEUSTART ist ZWINGEND ERFORDERLICH!" -ForegroundColor Yellow
Write-Host ""
Write-Host "Nach dem Neustart sollten funktionieren:" -ForegroundColor Cyan
Write-Host "- Taskleiste links" -ForegroundColor White
Write-Host "- Klassisches Kontextmenu (Rechtsklick auf Dateien)" -ForegroundColor White
Write-Host "- Kompakte Explorer-Ansicht" -ForegroundColor White
Write-Host ""
Write-Host "Falls Windows 10 Startmenu nicht funktioniert:" -ForegroundColor Yellow
Write-Host "-> ExplorerPatcher ARM64 unterstuetzt evtl. nicht alle Features" -ForegroundColor Yellow
Write-Host "-> Rechtsklick auf Taskleiste > Properties > Start menu style" -ForegroundColor Yellow
Write-Host ""

$restart = Read-Host "Neustart JETZT durchfuehren? (J/N)"
if ($restart -match '^[JjYy]') { 
    Restart-Computer -Force 
}
Pause
